<?php
// Home Controller

class Home {
    public function index() {
        require_once 'models/Employee.php';
        
        // Create an instance of the EmployeeModel
        $employeeModel = new Employee();
        
        // Retrieve employee data from the model
        $employees = $employeeModel->getAllEmployees(); // Assuming a method like getAllEmployees() to fetch all employees
        
        
        // Load the dashboard view with employee data
        require_once 'views/home.php';
    }

    public function addEmployee() {
        require_once 'models/Employee.php';
        
        $employeeModel = new Employee();
        
        // Parse form data
        $employeeData = array(
            'employeeId' => $_POST['employeeId'],
            'firstName' => $_POST['firstName'],
            'middleName' => $_POST['middleName'],
            'lastName' => $_POST['lastName'],
            'dateHired' => $_POST['dateHired'],
            'department' => $_POST['department'],
            'position' => $_POST['position'],
            'status' => $_POST['status']
        );

        $educationData = array(
            'employeeId' => $_POST['employeeId'],
            'school' => $_POST['school'],
            'yearGraduated' => $_POST['yearGraduated'],
            'course' => $_POST['course'],
            'level' => $_POST['level']
        );

        // Parse work experience data
        $workExperienceData = array();
        $numOfExperiences = count($_POST['company']);
        for ($i = 0; $i < $numOfExperiences; $i++) {
            // Check if fromDate and toDate are set
            $inclusiveDate = isset($_POST['fromDate'][$i]) && isset($_POST['toDate'][$i]) ? $_POST['fromDate'][$i] . ' - ' . $_POST['toDate'][$i] : null;
            $workExperienceData[] = array(
                'company' => $_POST['company'][$i],
                'workPosition' => $_POST['workPosition'][$i],
                'inclusiveDate' => $inclusiveDate,
                'salary' => $_POST['salary'][$i],
            );
        }

        // Call addEmployee method in the Employee model
        $success = $employeeModel->addEmployee($employeeData, $educationData, $workExperienceData);


        if ($success) {
            // Redirect to home page or show success message
            header('Location: index.php?url=home');
            exit();
        } else {
            // Handle failure
            echo "Failed to add employee.";
        }
    }

    public function deleteEmployee() {
        require_once 'models/Employee.php';
    
        $employeeModel = new Employee();
        $employeeId = $_POST['employee_id'];
    
        // Delete employee data from the database
        $success = $employeeModel->deleteEmployee($employeeId);
    
        // If the deletion was successful, redirect to home page
        if ($success) {
            header("Location: index.php?url=home");
            exit();
        } else {
            echo "Failed to add employee.";
        }
    }

    public function viewEmployeeDetails() {
        if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['employeeId'])) {
            $employeeId = $_GET['employeeId'];
    
            // Load necessary model(s) and fetch employee details based on $employeeId
            require_once 'models/Employee.php';
            $employeeModel = new Employee();
            $employeeData = $employeeModel->getEmployeeById($employeeId);
            $employeeDataWorkexperience = $employeeModel->getEmployeeWorkExperienceById($employeeId);
    
            // Load the modal view with the employee data
            ob_start();
        
                include 'views/employee_modal.php';
            
            $modalContent = ob_get_clean();
            echo $modalContent;
        }
    }

    public function updateEmployee() {
        require_once 'models/Employee.php';
        
        $employeeModel = new Employee();
        
        // Parse form data
        $employeeData = array(
            'employeeId' => $_POST['employeeId'],
            'firstName' => $_POST['firstName'],
            'middleName' => $_POST['middleName'],
            'lastName' => $_POST['lastName'],
            'dateHired' => $_POST['dateHired'],
            'department' => $_POST['department'],
            'position' => $_POST['position'],
            'status' => $_POST['status']
        );

        $educationData = array(
            'employeeId' => $_POST['employeeId'],
            'school' => $_POST['school'],
            'yearGraduated' => $_POST['yearGraduated'],
            'course' => $_POST['course'],
            'level' => $_POST['level']
        );

        // Parse work experience data
        $workExperienceData = array();
        foreach ($_POST as $key => $value) {
            // Check if the key represents a work experience field
            if (strpos($key, 'company_') === 0) {
                $index = substr($key, strlen('company_'));
                $workExperienceData[$index] = array(
                    'company' => $_POST['company_' . $index],
                    'workPosition' => $_POST['workPosition_' . $index],
                    'inclusiveDate' => $_POST['inclusiveDate_' . $index],
                    'salary' => $_POST['salary_' . $index],
                );
            }
        }

        // Call updateEmployee method in the Employee model
        $success = $employeeModel->updateEmployee($employeeData, $educationData, $workExperienceData);

        if ($success) {

            header('Location: index.php?url=home');
            exit();
        } else {
            echo "Failed to update employee.";
        }
    }

    
    
}
?>
