<!DOCTYPE html>
<html>
<head>
    <title>Dashboard</title>
    <link rel="stylesheet" type="text/css" href="css/styles.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <style>
    </style>
</head>
<body>

<?php include 'header.php'; ?>

<!-- Add Modal -->
<?php include 'modal.php'; ?>

<!-- Modal -->
<div class="modal fade" id="employeeModal" tabindex="-1" role="dialog" aria-labelledby="employeeModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content" id="modalContent">
      <!-- Modal content will be dynamically loaded here -->
    </div>
  </div>
</div>

    <!-- Employee Table -->
    <table>
    <thead>
        <tr>
            <th>Employee ID</th>
            <th>Name</th>
            <th>Date Hired</th>
            <th>Department</th>
            <th>Position</th>
            <th>Status</th>
            <th>Action</th>
        </tr>
    </thead>
    <tbody>
    <?php foreach ($employees as $employee) : ?>
        <tr>
            <td><?php echo $employee['Employee_ID']; ?></td>
            <td><?php echo $employee['FirstName'] . ' ' . $employee['LastName']; ?></td>
            <td><?php echo $employee['Date_Hired']; ?></td>
            <td><?php echo $employee['Department']; ?></td>
            <td><?php echo $employee['Position']; ?></td>
            <td><?php echo $employee['Status']; ?></td>
            <td>
                <!-- Button to open modal -->
                <button type="button" class="btn btn-primary view-details" data-employee-id="<?php echo $employee['Employee_ID']; ?>">
                View Details
                </button>
                <form id="deleteForm" action="index.php?url=home/deleteEmployee" method="post">
                    <input type="hidden" name="employee_id" value="<?php echo $employee['Employee_ID']; ?>">
                    <button type="button" id="deleteButton">Delete</button>
                </form>
            </td>
        </tr>
    <?php endforeach; ?>
    </tbody>
    </table>




<script>
        // JavaScript functions to open and close the modal
        function openModal() {
            document.getElementById('myModal').style.display = 'block';
        }

        function closeModal() {
            document.getElementById('myModal').style.display = 'none';
        }

        // JavaScript to add more work experience fields
        var workExperienceContainer = document.getElementById('workExperienceContainer');
        var addWorkExperienceButton = document.getElementById('addWorkExperience');

        addWorkExperienceButton.addEventListener('click', function () {
        var newWorkExperienceEntry = document.createElement('div');
        newWorkExperienceEntry.classList.add('workExperienceEntry');

        newWorkExperienceEntry.innerHTML = `
            <label for="company">Company:</label>
            <input type="text" name="company[]" required>

            <label for="workPosition">Position:</label>
            <input type="text" name="workPosition[]" required>

            <label for="fromDate">Inclusive Dates (From-To):</label>
            <input type="text" name="fromDate[]" placeholder="From" required>
            <input type="text" name="toDate[]" placeholder="To" required>

            <label for="salary">Salary:</label>
            <input type="text" name="salary[]" required>
            `;

        // Add remove button to the new work experience entry
        var removeButton = document.createElement('button');
        removeButton.type = 'button';
        removeButton.classList.add('removeWorkExperience');
        removeButton.textContent = 'Remove';
        newWorkExperienceEntry.appendChild(removeButton);

        workExperienceContainer.appendChild(newWorkExperienceEntry);
    });

        // Event delegation to handle remove button clicks
        $(document).on('click', '.removeWorkExperience', function() {
            $(this).closest('.workExperienceEntry').remove();
    });

        $(document).ready(function() {
            $('.view-details').click(function() {
                var employeeId = $(this).data('employee-id');
                $.ajax({
                    type: 'GET',
                    url: 'index.php?url=home/viewEmployeeDetails',
                    data: { employeeId: employeeId },
                    success: function(response) {
                        $('#modalContent').html(response);
                        $('#employeeModal').modal('show');
                    },
                    error: function(xhr, status, error) {
                        console.error(xhr.responseText);
                }
            });
        });
    });

        document.getElementById('deleteButton').addEventListener('click', function() {
                // Show confirmation dialog
                var confirmation = confirm('Are you sure you want to delete this employee?');
                
                // If user confirms, submit the form
            if (confirmation) {
                document.getElementById('deleteForm').submit();
        }
    });
    
    </script>
</body>
</html>