<!DOCTYPE html>
<html>
<head>
    <title>Login</title>
    <link rel="stylesheet" type="text/css" href="css/styles.css">
    <style>
        .login-container {
            position: relative;
        }

        .error-modal {
            display: none;
            position: absolute;
            top: 0;
            left: 50%;
            transform: translate(-50%, -150%);
            width: 300px; /* Adjust the width as needed */
            background-color: rgba(0, 0, 0, 0.5);
            padding: 20px;
            border-radius: 5px;
            color: white;
            z-index: 999;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <h2>Login</h2>
        <form action="index.php?url=login/login" method="post">
            <div class="input-group">
                <label for="username">Username:</label>
                <input type="text" id="username" name="username" required>
            </div>
            <div class="input-group">
                <label for="password">Password:</label>
                <input type="password" id="password" name="password" required>
            </div>
            <button type="submit" class="btn">Login</button>
        </form>

        <div id="errorModal" class="error-modal"></div>
    </div>

    <script>
        // Function to display error message as a modal and will hide it after a certain duration
        function displayErrorModal(message, duration) {
            let errorModal = document.getElementById('errorModal');
            errorModal.textContent = message;
            errorModal.style.display = 'block';

            setTimeout(function() {
                errorModal.style.display = 'none';
            }, duration);
        }

        // Getting error message from PHP and display it as a popup modal
        let errorMessage = "<?php echo $errorMessage; ?>";
        if (errorMessage !== '') {
            displayErrorModal(errorMessage, 1000); // Display modal for 5 seconds
        }
    </script>
</body>
</html>